/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import java.io.Serializable;
import rpgboss.lib.ArrayUtils$;
import rpgboss.lib.ThreadChecked;
import rpgboss.lib.ThreadChecked$class;
import rpgboss.model.CharClass;
import rpgboss.model.Character;
import rpgboss.model.Item;
import rpgboss.model.ItemType$;
import rpgboss.model.MapLoc;
import rpgboss.model.MapLoc$;
import rpgboss.model.ProjectData;
import rpgboss.model.battle.BattleStatus;
import rpgboss.model.battle.BattleStatus$;
import rpgboss.model.battle.PartyParameters;
import rpgboss.player.EventStateChange;
import rpgboss.player.HasScriptConstants;
import rpgboss.player.HasScriptConstants$class;
import rpgboss.player.IntArrayChange;
import rpgboss.player.IntChange;
import rpgboss.player.PersistentState$;
import rpgboss.player.PersistentStateUpdate;
import rpgboss.player.ScriptInterfaceConstants$;
import rpgboss.save.SaveFile;
import rpgboss.save.SavedEventState;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Predef$DummyImplicit$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Publisher;
import scala.collection.mutable.Publisher$class;
import scala.collection.mutable.Set;
import scala.collection.mutable.Subscriber;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\tee\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002U3sg&\u001cH/\u001a8u'R\fG/\u001a\u0006\u0003\u0007\u0011\ta\u0001\u001d7bs\u0016\u0014(\"A\u0003\u0002\u000fI\u0004xMY8tg\u000e\u00011C\u0002\u0001\t\u001dQ\u00013\u0005\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\t1\u0001\\5c\u0013\t\u0019\u0002CA\u0007UQJ,\u0017\rZ\"iK\u000e\\W\r\u001a\t\u0004+iaR\"\u0001\f\u000b\u0005]A\u0012aB7vi\u0006\u0014G.\u001a\u0006\u00033)\t!bY8mY\u0016\u001cG/[8o\u0013\tYbCA\u0005Qk\nd\u0017n\u001d5feB\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002\u0016!\u0016\u00148/[:uK:$8\u000b^1uKV\u0003H-\u0019;f!\ti\u0012%\u0003\u0002#\u0005\t\u0011\u0002*Y:TGJL\u0007\u000f^\"p]N$\u0018M\u001c;t!\t!S&D\u0001&\u0015\t1s%A\u0003tY\u001a$$N\u0003\u0002)S\u0005a1oY1mC2|wmZ5oO*\u0011!fK\u0001\tif\u0004Xm]1gK*\tA&A\u0002d_6L!AL\u0013\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u00059\u0011N\\5uS\u0006d\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0005\u0003\u0011\u0019\u0018M^3\n\u0005Y\u001a$\u0001C*bm\u00164\u0015\u000e\\3\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\tQ4\b\u0005\u0002\u001e\u0001!9\u0001g\u000eI\u0001\u0002\u0004\t\u0004bB\u001f\u0001\u0005\u0004%IAP\u0001\u0007S:$X*\u00199\u0016\u0003}\u0002B!\u0006!C\u0013&\u0011\u0011I\u0006\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019eI\u0004\u0002\n\t&\u0011QIC\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F\u0015A\u0011\u0011BS\u0005\u0003\u0017*\u00111!\u00138u\u0011\u0019i\u0005\u0001)A\u0005\u007f\u00059\u0011N\u001c;NCB\u0004\u0003bB(\u0001\u0005\u0004%I\u0001U\u0001\ngR\u0014\u0018N\\4NCB,\u0012!\u0015\t\u0005+\u0001\u0013%\t\u0003\u0004T\u0001\u0001\u0006I!U\u0001\u000bgR\u0014\u0018N\\4NCB\u0004\u0003bB+\u0001\u0005\u0004%IAV\u0001\fS:$\u0018I\u001d:bs6\u000b\u0007/F\u0001X!\u0011)\u0002I\u0011-\u0011\u0007%I\u0016*\u0003\u0002[\u0015\t)\u0011I\u001d:bs\"1A\f\u0001Q\u0001\n]\u000bA\"\u001b8u\u0003J\u0014\u0018-_'ba\u0002BqA\u0018\u0001C\u0002\u0013%q,\u0001\btiJLgnZ!se\u0006LX*\u00199\u0016\u0003\u0001\u0004B!\u0006!CCB\u0019\u0011\"\u0017\"\t\r\r\u0004\u0001\u0015!\u0003a\u0003=\u0019HO]5oO\u0006\u0013(/Y=NCB\u0004\u0003bB3\u0001\u0005\u0004%IAZ\u0001\n[\u0006\u0004Hj\\2NCB,\u0012a\u001a\t\u0005+\u0001\u0013\u0005\u000e\u0005\u0002jY6\t!N\u0003\u0002l\t\u0005)Qn\u001c3fY&\u0011QN\u001b\u0002\u0007\u001b\u0006\u0004Hj\\2\t\r=\u0004\u0001\u0015!\u0003h\u0003)i\u0017\r\u001d'pG6\u000b\u0007\u000f\t\u0005\bc\u0002\u0011\r\u0011\"\u0003s\u0003-)g/\u001a8u'R\fG/Z:\u0016\u0003M\u0004B!\u0006!u\u0013B!\u0011\"\u001e\"J\u0013\t1(B\u0001\u0004UkBdWM\r\u0005\u0007q\u0002\u0001\u000b\u0011B:\u0002\u0019\u00154XM\u001c;Ti\u0006$Xm\u001d\u0011\t\u000bi\u0004A\u0011A>\u0002\u001dQ|7+\u001a:jC2L'0\u00192mKV\t\u0011\u0007C\u0003~\u0001\u0011\u0005a0\u0001\u0004hKRdun\u0019\u000b\u0003Q~Da!!\u0001}\u0001\u0004\u0011\u0015aA6fs\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011AB:fi2{7\r\u0006\u0004\u0002\n\u0005=\u0011\u0011\u0003\t\u0004\u0013\u0005-\u0011bAA\u0007\u0015\t!QK\\5u\u0011\u001d\t\t!a\u0001A\u0002\tCq!a\u0005\u0002\u0004\u0001\u0007\u0001.A\u0002m_\u000eDq!a\u0006\u0001\t\u0003\tI\"\u0001\u0004tKRLe\u000e\u001e\u000b\u0007\u0003\u0013\tY\"!\b\t\u000f\u0005\u0005\u0011Q\u0003a\u0001\u0005\"9\u0011qDA\u000b\u0001\u0004I\u0015!\u0002<bYV,\u0007bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u0007O\u0016$\u0018J\u001c;\u0015\u0007%\u000b9\u0003C\u0004\u0002\u0002\u0005\u0005\u0002\u0019\u0001\"\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u00051\u0001.Y:J]R$B!a\f\u00026A\u0019\u0011\"!\r\n\u0007\u0005M\"BA\u0004C_>dW-\u00198\t\u000f\u0005\u0005\u0011\u0011\u0006a\u0001\u0005\"9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0012!C:fiN#(/\u001b8h)\u0019\tI!!\u0010\u0002@!9\u0011\u0011AA\u001c\u0001\u0004\u0011\u0005bBA\u0010\u0003o\u0001\rA\u0011\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003%9W\r^*ue&tw\rF\u0002C\u0003\u000fBq!!\u0001\u0002B\u0001\u0007!\tC\u0004\u0002L\u0001!\t!!\u0014\u0002\u0017\u001d,G/\u00138u\u0003J\u0014\u0018-\u001f\u000b\u00041\u0006=\u0003bBA\u0001\u0003\u0013\u0002\rA\u0011\u0005\b\u0003'\u0002A\u0011AA+\u0003-\u0019X\r^%oi\u0006\u0013(/Y=\u0015\r\u0005%\u0011qKA-\u0011\u001d\t\t!!\u0015A\u0002\tCq!a\b\u0002R\u0001\u0007\u0001\fC\u0004\u0002^\u0001!\t!a\u0018\u0002-M,G/\u00138u\u0003J\u0014\u0018-\u001f(p\u001fZ,'o\u001e:ji\u0016$b!!\u0003\u0002b\u0005\r\u0004bBA\u0001\u00037\u0002\rA\u0011\u0005\b\u0003?\tY\u00061\u0001Y\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nabZ3u'R\u0014\u0018N\\4BeJ\f\u0017\u0010F\u0002b\u0003WBq!!\u0001\u0002f\u0001\u0007!\tC\u0004\u0002p\u0001!\t!!\u001d\u0002\u001dM,Go\u0015;sS:<\u0017I\u001d:bsR1\u0011\u0011BA:\u0003kBq!!\u0001\u0002n\u0001\u0007!\tC\u0004\u0002 \u00055\u0004\u0019A1\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|\u0005I2/\u001a;TiJLgnZ!se\u0006Lhj\\(wKJ<(/\u001b;f)\u0019\tI!! \u0002\u0000!9\u0011\u0011AA<\u0001\u0004\u0011\u0005bBA\u0010\u0003o\u0002\r!\u0019\u0005\b\u0003\u0007\u0003A\u0011AAC\u000359W\r^#wK:$8\u000b^1uKR)\u0011*a\"\u0002\f\"9\u0011\u0011RAA\u0001\u0004\u0011\u0015aB7ba:\u000bW.\u001a\u0005\b\u0003\u001b\u000b\t\t1\u0001J\u0003\u001d)g/\u001a8u\u0013\u0012Dq!!%\u0001\t\u0003\t\u0019*A\u0007tKR,e/\u001a8u'R\fG/\u001a\u000b\t\u0003\u0013\t)*a&\u0002\u001a\"9\u0011\u0011RAH\u0001\u0004\u0011\u0005bBAG\u0003\u001f\u0003\r!\u0013\u0005\b\u00037\u000by\t1\u0001J\u0003!qWm^*uCR,\u0007bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\u0011O\u0016$8\t[1sC\u000e$XM\u001d(b[\u0016$RAQAR\u0003[C\u0001\"!*\u0002\u001e\u0002\u0007\u0011qU\u0001\u0006a\u0012\u000bG/\u0019\t\u0004S\u0006%\u0016bAAVU\nY\u0001K]8kK\u000e$H)\u0019;b\u0011\u001d\ty+!(A\u0002%\u000b1b\u00195be\u0006\u001cG/\u001a:JI\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0016AE4fiB\u000b'\u000f^=QCJ\fW.\u001a;feN$B!a.\u0002DB!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>*\faAY1ui2,\u0017\u0002BAa\u0003w\u0013q\u0002U1sif\u0004\u0016M]1nKR,'o\u001d\u0005\t\u0003\u000b\f\t\f1\u0001\u0002H\u0006Q1\r[1sC\u000e$XM]:\u0011\t%I\u0016\u0011\u001a\t\u0004S\u0006-\u0017bAAgU\nI1\t[1sC\u000e$XM\u001d\u0005\b\u0003#\u0004A\u0011AAj\u000399\u0017N^3FqB,'/[3oG\u0016$r\u0001WAk\u0003/\fY\u000e\u0003\u0005\u0002&\u0006=\u0007\u0019AAT\u0011\u001d\tI.a4A\u0002a\u000bAb\u00195be\u0006\u001cG/\u001a:JINDq!!8\u0002P\u0002\u0007\u0011*\u0001\u0006fqB,'/[3oG\u0016Dq!!9\u0001\t\u0003\t\u0019/\u0001\ntKR\u001c\u0005.\u0019:bGR,'\u000fT3wK2\u001cH\u0003CA\u0005\u0003K\f9/!;\t\u0011\u0005\u0015\u0016q\u001ca\u0001\u0003OCq!!7\u0002`\u0002\u0007\u0001\fC\u0004\u0002l\u0006}\u0007\u0019A%\u0002\u00119,w\u000fT3wK2Dq!a<\u0001\t\u0013\t\t0\u0001\u0011bI*,8\u000f^\"iCJ\f7\r^3s-&$\u0018\r\\:G_JdUM^3mS:<G\u0003CA\u0005\u0003g\f)0!?\t\u0011\u0005\u0015\u0016Q\u001ea\u0001\u0003OC\u0001\"a>\u0002n\u0002\u0007\u0011qW\u0001\u000f_2$\u0007+\u0019:usB\u000b'/Y7t\u0011\u001d\tI.!<A\u0002aCq!!@\u0001\t\u0003\ty0A\ntCZ,7\t[1sC\u000e$XM\u001d,ji\u0006d7\u000f\u0006\u0006\u0002\n\t\u0005!1\u0001B\u0004\u0005\u0017Aq!a,\u0002|\u0002\u0007\u0011\nC\u0004\u0003\u0006\u0005m\b\u0019A%\u0002\u0005!\u0004\bb\u0002B\u0005\u0003w\u0004\r!S\u0001\u0003[BDqA!\u0004\u0002|\u0002\u0007\u0001,A\nuK6\u00048\u000b^1ukN,eMZ3di&#7\u000fC\u0004\u0003\u0012\u0001!\tAa\u0005\u0002\u00175|G-\u001b4z!\u0006\u0014H/\u001f\u000b\u0007\u0003_\u0011)B!\u0007\t\u0011\t]!q\u0002a\u0001\u0003_\t1!\u00193e\u0011\u001d\tyKa\u0004A\u0002%CqA!\b\u0001\t\u0003\u0011y\"A\u0007bI\u0012\u0014V-\\8wK&#X-\u001c\u000b\u0007\u0003_\u0011\tC!\n\t\u000f\t\r\"1\u0004a\u0001\u0013\u00061\u0011\u000e^3n\u0013\u0012DqAa\n\u0003\u001c\u0001\u0007\u0011*\u0001\u0005rif$U\r\u001c;b\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[\t!bY8v]RLE/Z7t)\rI%q\u0006\u0005\b\u0005G\u0011I\u00031\u0001J\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005k\t!cZ3u\u000bF,\u0018\u000e\u001d9bE2,\u0017\n^3ngR9\u0001La\u000e\u0003:\tm\u0002\u0002CAS\u0005c\u0001\r!a*\t\u000f\u0005=&\u0011\u0007a\u0001\u0013\"9!Q\bB\u0019\u0001\u0004I\u0015aC3rk&\u0004H+\u001f9f\u0013\u0012DqA!\u0011\u0001\t\u0003\u0011\u0019%\u0001\bhKR\u0014\u0015\r\u001e;mK&#X-\\:\u0015\t\t\u0015#\u0011\n\t\u0005\u0013e\u00139\u0005\u0005\u0003\nk&K\u0005\u0002CAS\u0005\u007f\u0001\r!a*\t\u000f\t5\u0003\u0001\"\u0001\u0003P\u0005IQ-];ja&#X-\u001c\u000b\t\u0003_\u0011\tFa\u0015\u0003X!9\u0011q\u0016B&\u0001\u0004I\u0005b\u0002B+\u0005\u0017\u0002\r!S\u0001\u0007g2|G/\u00133\t\u000f\t\r\"1\na\u0001\u0013\"9!1\f\u0001\u0005\u0002\tu\u0013AF1eIJ+Wn\u001c<f\u0019\u0016\f'O\\3e'.LG\u000e\\:\u0015\u0011\u0005%!q\fB1\u0005GB\u0001Ba\u0006\u0003Z\u0001\u0007\u0011q\u0006\u0005\b\u0003_\u0013I\u00061\u0001J\u0011\u001d\u0011)G!\u0017A\u0002%\u000bqa]6jY2LE\rC\u0004\u0003j\u0001!\tAa\u001b\u0002\u001b\u0005$GMU3n_Z,wi\u001c7e)\u0011\tyC!\u001c\t\u000f\t=$q\ra\u0001\u0013\u0006)A-\u001a7uC\u001eI!1\u000f\u0002\u0002\u0002#\u0005!QO\u0001\u0010!\u0016\u00148/[:uK:$8\u000b^1uKB\u0019QDa\u001e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0005s\u001a2Aa\u001e\t\u0011\u001dA$q\u000fC\u0001\u0005{\"\"A!\u001e\t\u0015\t\u0005%qOI\u0001\n\u0003\u0011\u0019)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000bS3!\rBDW\t\u0011I\t\u0005\u0003\u0003\f\nUUB\u0001BG\u0015\u0011\u0011yI!%\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BJ\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]%Q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class PersistentState
implements ThreadChecked,
Publisher<PersistentStateUpdate>,
HasScriptConstants,
LazyLogging {
    private final HashMap<String, Object> intMap;
    private final HashMap<String, String> stringMap;
    private final HashMap<String, int[]> intArrayMap;
    private final HashMap<String, String[]> stringArrayMap;
    private final HashMap<String, MapLoc> mapLocMap;
    private final HashMap<Tuple2<String, Object>, Object> eventStates;
    private final Logger logger;
    private final int LEFT;
    private final int CENTER;
    private final int RIGHT;
    private final String PLAYER_LOC;
    private final String GOLD;
    private final String PLAYER_MOVEMENT_LOCKS;
    private final String EVENTS_ENABLED;
    private final String MENU_ENABLED;
    private final String PARTY;
    private final String INVENTORY_ITEM_IDS;
    private final String INVENTORY_QTYS;
    private final String CHARACTER_NAMES;
    private final String CHARACTER_LEVELS;
    private final String CHARACTER_HPS;
    private final String CHARACTER_MPS;
    private final String CHARACTER_EXPS;
    private final String CHARACTER_ROWS;
    private final int CENTERED;
    private final int NORTH;
    private final int EAST;
    private final int SOUTH;
    private final int WEST;
    private final int NORTHEAST;
    private final int SOUTHEAST;
    private final int SOUTHWEST;
    private final int NORTHWEST;
    private final int FIXED;
    private final int SCALE_SOURCE;
    private final int SCREEN;
    private final int COVER;
    private final int CONTAIN;
    private final Publisher self;
    private final HashMap<Subscriber<Object, Publisher>, Set<Function1<Object, Object>>> scala$collection$mutable$Publisher$$filters;
    private final HashSet<Subscriber<Object, Publisher>> scala$collection$mutable$Publisher$$suspended;
    private Thread rpgboss$lib$ThreadChecked$$_boundThread;
    private volatile boolean bitmap$0;

    public static SaveFile $lessinit$greater$default$1() {
        return PersistentState$.MODULE$.$lessinit$greater$default$1();
    }

    private Logger logger$lzycompute() {
        PersistentState persistentState = this;
        synchronized (persistentState) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int LEFT() {
        return this.LEFT;
    }

    @Override
    public int CENTER() {
        return this.CENTER;
    }

    @Override
    public int RIGHT() {
        return this.RIGHT;
    }

    @Override
    public String PLAYER_LOC() {
        return this.PLAYER_LOC;
    }

    @Override
    public String GOLD() {
        return this.GOLD;
    }

    @Override
    public String PLAYER_MOVEMENT_LOCKS() {
        return this.PLAYER_MOVEMENT_LOCKS;
    }

    @Override
    public String EVENTS_ENABLED() {
        return this.EVENTS_ENABLED;
    }

    @Override
    public String MENU_ENABLED() {
        return this.MENU_ENABLED;
    }

    @Override
    public String PARTY() {
        return this.PARTY;
    }

    @Override
    public String INVENTORY_ITEM_IDS() {
        return this.INVENTORY_ITEM_IDS;
    }

    @Override
    public String INVENTORY_QTYS() {
        return this.INVENTORY_QTYS;
    }

    @Override
    public String CHARACTER_NAMES() {
        return this.CHARACTER_NAMES;
    }

    @Override
    public String CHARACTER_LEVELS() {
        return this.CHARACTER_LEVELS;
    }

    @Override
    public String CHARACTER_HPS() {
        return this.CHARACTER_HPS;
    }

    @Override
    public String CHARACTER_MPS() {
        return this.CHARACTER_MPS;
    }

    @Override
    public String CHARACTER_EXPS() {
        return this.CHARACTER_EXPS;
    }

    @Override
    public String CHARACTER_ROWS() {
        return this.CHARACTER_ROWS;
    }

    @Override
    public int CENTERED() {
        return this.CENTERED;
    }

    @Override
    public int NORTH() {
        return this.NORTH;
    }

    @Override
    public int EAST() {
        return this.EAST;
    }

    @Override
    public int SOUTH() {
        return this.SOUTH;
    }

    @Override
    public int WEST() {
        return this.WEST;
    }

    @Override
    public int NORTHEAST() {
        return this.NORTHEAST;
    }

    @Override
    public int SOUTHEAST() {
        return this.SOUTHEAST;
    }

    @Override
    public int SOUTHWEST() {
        return this.SOUTHWEST;
    }

    @Override
    public int NORTHWEST() {
        return this.NORTHWEST;
    }

    @Override
    public int FIXED() {
        return this.FIXED;
    }

    @Override
    public int SCALE_SOURCE() {
        return this.SCALE_SOURCE;
    }

    @Override
    public int SCREEN() {
        return this.SCREEN;
    }

    @Override
    public int COVER() {
        return this.COVER;
    }

    @Override
    public int CONTAIN() {
        return this.CONTAIN;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$LEFT_$eq(int x$1) {
        this.LEFT = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CENTER_$eq(int x$1) {
        this.CENTER = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$RIGHT_$eq(int x$1) {
        this.RIGHT = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PLAYER_LOC_$eq(String x$1) {
        this.PLAYER_LOC = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$GOLD_$eq(String x$1) {
        this.GOLD = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PLAYER_MOVEMENT_LOCKS_$eq(String x$1) {
        this.PLAYER_MOVEMENT_LOCKS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$EVENTS_ENABLED_$eq(String x$1) {
        this.EVENTS_ENABLED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$MENU_ENABLED_$eq(String x$1) {
        this.MENU_ENABLED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$PARTY_$eq(String x$1) {
        this.PARTY = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$INVENTORY_ITEM_IDS_$eq(String x$1) {
        this.INVENTORY_ITEM_IDS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$INVENTORY_QTYS_$eq(String x$1) {
        this.INVENTORY_QTYS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_NAMES_$eq(String x$1) {
        this.CHARACTER_NAMES = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_LEVELS_$eq(String x$1) {
        this.CHARACTER_LEVELS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_HPS_$eq(String x$1) {
        this.CHARACTER_HPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_MPS_$eq(String x$1) {
        this.CHARACTER_MPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_EXPS_$eq(String x$1) {
        this.CHARACTER_EXPS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CHARACTER_ROWS_$eq(String x$1) {
        this.CHARACTER_ROWS = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CENTERED_$eq(int x$1) {
        this.CENTERED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTH_$eq(int x$1) {
        this.NORTH = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$EAST_$eq(int x$1) {
        this.EAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTH_$eq(int x$1) {
        this.SOUTH = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$WEST_$eq(int x$1) {
        this.WEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTHEAST_$eq(int x$1) {
        this.NORTHEAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTHEAST_$eq(int x$1) {
        this.SOUTHEAST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SOUTHWEST_$eq(int x$1) {
        this.SOUTHWEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$NORTHWEST_$eq(int x$1) {
        this.NORTHWEST = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$FIXED_$eq(int x$1) {
        this.FIXED = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SCALE_SOURCE_$eq(int x$1) {
        this.SCALE_SOURCE = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$SCREEN_$eq(int x$1) {
        this.SCREEN = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$COVER_$eq(int x$1) {
        this.COVER = x$1;
    }

    @Override
    public void rpgboss$player$HasScriptConstants$_setter_$CONTAIN_$eq(int x$1) {
        this.CONTAIN = x$1;
    }

    @Override
    public String VEHICLE_LOC(int vehicleId) {
        return HasScriptConstants$class.VEHICLE_LOC(this, vehicleId);
    }

    @Override
    public String CHARACTER_EQUIP(int characterId) {
        return HasScriptConstants$class.CHARACTER_EQUIP(this, characterId);
    }

    @Override
    public String CHARACTER_STATUS_EFFECTS(int characterId) {
        return HasScriptConstants$class.CHARACTER_STATUS_EFFECTS(this, characterId);
    }

    @Override
    public String CHARACTER_LEARNED_SKILLS(int characterId) {
        return HasScriptConstants$class.CHARACTER_LEARNED_SKILLS(this, characterId);
    }

    @Override
    public Publisher self() {
        return this.self;
    }

    @Override
    public HashMap<Subscriber<PersistentStateUpdate, Publisher>, Set<Function1<PersistentStateUpdate, Object>>> scala$collection$mutable$Publisher$$filters() {
        return this.scala$collection$mutable$Publisher$$filters;
    }

    @Override
    public HashSet<Subscriber<PersistentStateUpdate, Publisher>> scala$collection$mutable$Publisher$$suspended() {
        return this.scala$collection$mutable$Publisher$$suspended;
    }

    @Override
    public void scala$collection$mutable$Publisher$_setter_$self_$eq(Publisher x$1) {
        this.self = x$1;
    }

    @Override
    public void scala$collection$mutable$Publisher$_setter_$scala$collection$mutable$Publisher$$filters_$eq(HashMap x$1) {
        this.scala$collection$mutable$Publisher$$filters = x$1;
    }

    @Override
    public void scala$collection$mutable$Publisher$_setter_$scala$collection$mutable$Publisher$$suspended_$eq(HashSet x$1) {
        this.scala$collection$mutable$Publisher$$suspended = x$1;
    }

    @Override
    public void subscribe(Subscriber<PersistentStateUpdate, Publisher> sub) {
        Publisher$class.subscribe(this, sub);
    }

    @Override
    public void subscribe(Subscriber<PersistentStateUpdate, Publisher> sub, Function1<PersistentStateUpdate, Object> filter2) {
        Publisher$class.subscribe(this, sub, filter2);
    }

    @Override
    public void suspendSubscription(Subscriber<PersistentStateUpdate, Publisher> sub) {
        Publisher$class.suspendSubscription(this, sub);
    }

    @Override
    public void activateSubscription(Subscriber<PersistentStateUpdate, Publisher> sub) {
        Publisher$class.activateSubscription(this, sub);
    }

    @Override
    public void removeSubscription(Subscriber<PersistentStateUpdate, Publisher> sub) {
        Publisher$class.removeSubscription(this, sub);
    }

    @Override
    public void removeSubscriptions() {
        Publisher$class.removeSubscriptions(this);
    }

    @Override
    public void publish(Object event) {
        Publisher$class.publish(this, event);
    }

    @Override
    public boolean equals(Object obj) {
        return Publisher$class.equals(this, obj);
    }

    @Override
    public Thread rpgboss$lib$ThreadChecked$$_boundThread() {
        return this.rpgboss$lib$ThreadChecked$$_boundThread;
    }

    @Override
    @TraitSetter
    public void rpgboss$lib$ThreadChecked$$_boundThread_$eq(Thread x$1) {
        this.rpgboss$lib$ThreadChecked$$_boundThread = x$1;
    }

    @Override
    public void rebindToCurrentThread() {
        ThreadChecked$class.rebindToCurrentThread(this);
    }

    @Override
    public void assertOnBoundThread() {
        ThreadChecked$class.assertOnBoundThread(this);
    }

    @Override
    public void assertOnDifferentThread() {
        ThreadChecked$class.assertOnDifferentThread(this);
    }

    @Override
    public boolean onBoundThread() {
        return ThreadChecked$class.onBoundThread(this);
    }

    private HashMap<String, Object> intMap() {
        return this.intMap;
    }

    private HashMap<String, String> stringMap() {
        return this.stringMap;
    }

    private HashMap<String, int[]> intArrayMap() {
        return this.intArrayMap;
    }

    private HashMap<String, String[]> stringArrayMap() {
        return this.stringArrayMap;
    }

    private HashMap<String, MapLoc> mapLocMap() {
        return this.mapLocMap;
    }

    private HashMap<Tuple2<String, Object>, Object> eventStates() {
        return this.eventStates;
    }

    public SaveFile toSerializable() {
        Iterable serializedEventStates = this.eventStates().map((Function1<Tuple2<String, Object>, Object>)((Object)new scala.Serializable(this){

            public final SavedEventState apply(Tuple2<Tuple2<String, Object>, Object> x0$1) {
                Tuple2<Tuple2<String, Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2<String, Object> tuple22 = tuple2._1();
                    int eventState = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        String mapName2 = tuple22._1();
                        int eventId = tuple22._2$mcI$sp();
                        SavedEventState savedEventState = new SavedEventState(mapName2, eventId, eventState);
                        return savedEventState;
                    }
                }
                throw new MatchError(tuple2);
            }
        }), Iterable$.MODULE$.canBuildFrom());
        return new SaveFile((Map<String, Object>)this.intMap().toMap(Predef$.MODULE$.$conforms()), (Map<String, String>)this.stringMap().toMap(Predef$.MODULE$.$conforms()), (Map<String, int[]>)this.intArrayMap().toMap(Predef$.MODULE$.$conforms()), (Map<String, String[]>)this.stringArrayMap().toMap(Predef$.MODULE$.$conforms()), (Map<String, MapLoc>)this.mapLocMap().toMap(Predef$.MODULE$.$conforms()), (SavedEventState[])serializedEventStates.toArray(ClassTag$.MODULE$.apply(SavedEventState.class)));
    }

    public MapLoc getLoc(String key) {
        return this.mapLocMap().getOrElse(key, new scala.Serializable(this){

            public final MapLoc apply() {
                return new MapLoc(MapLoc$.MODULE$.apply$default$1(), MapLoc$.MODULE$.apply$default$2(), MapLoc$.MODULE$.apply$default$3());
            }
        });
    }

    public void setLoc(String key, MapLoc loc) {
        this.mapLocMap().update(key, loc);
    }

    public void setInt(String key, int value2) {
        this.assertOnBoundThread();
        this.intMap().update(key, BoxesRunTime.boxToInteger(value2));
        this.publish(new IntChange(key, value2));
    }

    public int getInt(String key) {
        this.assertOnBoundThread();
        return BoxesRunTime.unboxToInt(this.intMap().get(key).getOrElse(new scala.Serializable(this){

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public boolean hasInt(String key) {
        this.assertOnBoundThread();
        return this.intMap().contains(key);
    }

    public void setString(String key, String value2) {
        this.assertOnBoundThread();
        this.stringMap().update(key, value2);
    }

    public String getString(String key) {
        this.assertOnBoundThread();
        return this.stringMap().get(key).getOrElse(new scala.Serializable(this){

            public final String apply() {
                return "";
            }
        });
    }

    public int[] getIntArray(String key) {
        this.assertOnBoundThread();
        return this.intArrayMap().get(key).map(new scala.Serializable(this){

            public final int[] apply(int[] x$1) {
                return (int[])x$1.clone();
            }
        }).getOrElse(new scala.Serializable(this){

            public final int[] apply() {
                return new int[0];
            }
        });
    }

    public void setIntArray(String key, int[] value2) {
        this.assertOnBoundThread();
        this.intArrayMap().update(key, (int[])Predef$.MODULE$.intArrayOps(value2).toArray(ClassTag$.MODULE$.Int()));
        this.publish(new IntArrayChange(key));
    }

    public void setIntArrayNoOverwrite(String key, int[] value2) {
        Predef$.MODULE$.intArrayOps(this.getIntArray(key)).copyToArray(value2);
        this.setIntArray(key, value2);
    }

    public String[] getStringArray(String key) {
        this.assertOnBoundThread();
        return this.stringArrayMap().get(key).map(new scala.Serializable(this){

            public final String[] apply(String[] x$2) {
                return (String[])x$2.clone();
            }
        }).getOrElse(new scala.Serializable(this){

            public final String[] apply() {
                return new String[0];
            }
        });
    }

    public void setStringArray(String key, String[] value2) {
        this.assertOnBoundThread();
        this.stringArrayMap().update(key, (String[])Predef$.MODULE$.refArrayOps((Object[])value2).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public void setStringArrayNoOverwrite(String key, String[] value2) {
        Predef$.MODULE$.refArrayOps((Object[])this.getStringArray(key)).copyToArray(value2);
        this.setStringArray(key, value2);
    }

    public int getEventState(String mapName2, int eventId) {
        this.assertOnBoundThread();
        return BoxesRunTime.unboxToInt(this.eventStates().get(new Tuple2<String, Integer>(mapName2, BoxesRunTime.boxToInteger(eventId))).getOrElse(new scala.Serializable(this){

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        }));
    }

    public void setEventState(String mapName2, int eventId, int newState) {
        this.assertOnBoundThread();
        this.eventStates().update(new Tuple2<String, Integer>(mapName2, BoxesRunTime.boxToInteger(eventId)), BoxesRunTime.boxToInteger(newState));
        this.publish(new EventStateChange(new Tuple2<String, Object>(mapName2, BoxesRunTime.boxToInteger(eventId)), newState));
    }

    public String getCharacterName(ProjectData pData, int characterId) {
        String string2;
        String[] names = this.getStringArray(ScriptInterfaceConstants$.MODULE$.CHARACTER_NAMES());
        if (characterId < names.length) {
            string2 = names[characterId];
        } else {
            Predef$.MODULE$.assert(characterId < pData.enums().characters().length);
            string2 = pData.enums().characters()[characterId].name();
        }
        return string2;
    }

    public PartyParameters getPartyParameters(Character[] characters2) {
        int[] charactersIdxs = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), characters2.length).toArray(ClassTag$.MODULE$.Int());
        return new PartyParameters(this.getIntArray(this.CHARACTER_LEVELS()), this.getIntArray(this.CHARACTER_HPS()), this.getIntArray(this.CHARACTER_MPS()), (int[][])Predef$.MODULE$.intArrayOps(charactersIdxs).map(new scala.Serializable(this){
            private final /* synthetic */ PersistentState $outer;

            public final int[] apply(int id) {
                return (int[])Predef$.MODULE$.intArrayOps(this.$outer.getIntArray(this.$outer.CHARACTER_EQUIP(id))).filter(new scala.Serializable(this){

                    public final boolean apply(int x$3) {
                        return this.apply$mcZI$sp(x$3);
                    }

                    public boolean apply$mcZI$sp(int x$3) {
                        return x$3 != -1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))), (int[][])Predef$.MODULE$.intArrayOps(charactersIdxs).map(new scala.Serializable(this){
            private final /* synthetic */ PersistentState $outer;

            public final int[] apply(int id) {
                return this.$outer.getIntArray(this.$outer.CHARACTER_STATUS_EFFECTS(id));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))), (int[][])Predef$.MODULE$.intArrayOps(charactersIdxs).map(new scala.Serializable(this){
            private final /* synthetic */ PersistentState $outer;

            public final int[] apply(int id) {
                return this.$outer.getIntArray(this.$outer.CHARACTER_LEARNED_SKILLS(id));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)))), this.getIntArray(this.CHARACTER_ROWS()));
    }

    public int[] giveExperience(ProjectData pData, int[] characterIds, int experience) {
        int[] levels = this.getIntArray(this.CHARACTER_LEVELS());
        int[] exps = this.getIntArray(this.CHARACTER_EXPS());
        PartyParameters oldPartyParams = this.getPartyParameters(this.rpgboss$player$PersistentState$$characters$1(pData));
        Predef$.MODULE$.assert(levels.length == this.rpgboss$player$PersistentState$$characters$1(pData).length);
        Predef$.MODULE$.assert(exps.length == this.rpgboss$player$PersistentState$$characters$1(pData).length);
        ArrayBuffer leveledBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Nil$.MODULE$);
        Predef$.MODULE$.intArrayOps(characterIds).foreach(new scala.Serializable(this, pData, experience, levels, exps, leveledBuffer){
            private final /* synthetic */ PersistentState $outer;
            private final ProjectData pData$2;
            private final int experience$1;
            private final int[] levels$1;
            private final int[] exps$1;
            private final ArrayBuffer leveledBuffer$1;

            public final Object apply(int i) {
                Object object;
                Character character = this.$outer.rpgboss$player$PersistentState$$characters$1(this.pData$2)[i];
                this.exps$1[i] = this.exps$1[i] + this.experience$1;
                boolean leveled = false;
                while (this.exps$1[i] >= character.expToLevel(this.levels$1[i])) {
                    this.exps$1[i] = this.exps$1[i] - character.expToLevel(this.levels$1[i]);
                    this.levels$1[i] = this.levels$1[i] + 1;
                    leveled = true;
                }
                if (leveled) {
                    character.expToLevel(this.levels$1[i]);
                    object = this.leveledBuffer$1.$plus$eq(BoxesRunTime.boxToInteger(i));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pData$2 = pData$2;
                this.experience$1 = experience$1;
                this.levels$1 = levels$1;
                this.exps$1 = exps$1;
                this.leveledBuffer$1 = leveledBuffer$1;
            }
        });
        this.setIntArray(this.CHARACTER_EXPS(), exps);
        this.setIntArray(this.CHARACTER_LEVELS(), levels);
        this.adjustCharacterVitalsForLeveling(pData, oldPartyParams, (int[])leveledBuffer.toArray(ClassTag$.MODULE$.Int()));
        return (int[])leveledBuffer.toArray(ClassTag$.MODULE$.Int());
    }

    public void setCharacterLevels(ProjectData pData, int[] characterIds, int newLevel) {
        PartyParameters oldPartyParams = this.getPartyParameters(this.characters$3(pData));
        int[] levels = this.getIntArray(this.CHARACTER_LEVELS());
        Predef$.MODULE$.intArrayOps(characterIds).foreach(new scala.Serializable(this, newLevel, levels){
            private final int newLevel$1;
            private final int[] levels$2;

            public final void apply(int id) {
                this.apply$mcVI$sp(id);
            }

            public void apply$mcVI$sp(int id) {
                this.levels$2[id] = this.newLevel$1;
            }
            {
                this.newLevel$1 = newLevel$1;
                this.levels$2 = levels$2;
            }
        });
        this.setIntArray(this.CHARACTER_LEVELS(), levels);
        this.adjustCharacterVitalsForLeveling(pData, oldPartyParams, characterIds);
    }

    private void adjustCharacterVitalsForLeveling(ProjectData pData, PartyParameters oldPartyParams, int[] characterIds) {
        int[] hps = this.getIntArray(this.CHARACTER_HPS());
        int[] mps = this.getIntArray(this.CHARACTER_MPS());
        PartyParameters newPartyParams = this.getPartyParameters(this.characters$2(pData));
        Predef$.MODULE$.intArrayOps(characterIds).foreach(new scala.Serializable(this, pData, oldPartyParams, hps, mps, newPartyParams){
            private final ProjectData pData$3;
            private final PartyParameters oldPartyParams$1;
            private final int[] hps$1;
            private final int[] mps$1;
            private final PartyParameters newPartyParams$1;

            public final void apply(int id) {
                this.apply$mcVI$sp(id);
            }

            public void apply$mcVI$sp(int id) {
                BattleStatus oldStats = BattleStatus$.MODULE$.fromCharacter(this.pData$3, this.oldPartyParams$1, id, BattleStatus$.MODULE$.fromCharacter$default$4());
                BattleStatus newStats = BattleStatus$.MODULE$.fromCharacter(this.pData$3, this.newPartyParams$1, id, BattleStatus$.MODULE$.fromCharacter$default$4());
                double hpRatio = (double)oldStats.hp() / (double)oldStats.stats().mhp();
                double mpRatio = (double)oldStats.mp() / (double)oldStats.stats().mmp();
                this.hps$1[id] = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(hpRatio * (double)newStats.stats().mhp()));
                this.mps$1[id] = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(mpRatio * (double)newStats.stats().mmp()));
            }
            {
                this.pData$3 = pData$3;
                this.oldPartyParams$1 = oldPartyParams$1;
                this.hps$1 = hps$1;
                this.mps$1 = mps$1;
                this.newPartyParams$1 = newPartyParams$1;
            }
        });
        this.setIntArray(this.CHARACTER_HPS(), hps);
        this.setIntArray(this.CHARACTER_MPS(), mps);
    }

    public void saveCharacterVitals(int characterId, int hp, int mp, int[] tempStatusEffectIds) {
        int[] hps = this.getIntArray(this.CHARACTER_HPS());
        int[] mps = this.getIntArray(this.CHARACTER_MPS());
        Predef$.MODULE$.assert(characterId < hps.length);
        Predef$.MODULE$.assert(characterId < mps.length);
        this.setIntArray(this.CHARACTER_HPS(), (int[])Predef$.MODULE$.intArrayOps(hps).updated(characterId, BoxesRunTime.boxToInteger(hp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        this.setIntArray(this.CHARACTER_MPS(), (int[])Predef$.MODULE$.intArrayOps(mps).updated(characterId, BoxesRunTime.boxToInteger(mp), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        this.setIntArray(this.CHARACTER_STATUS_EFFECTS(characterId), tempStatusEffectIds);
    }

    public boolean modifyParty(boolean add3, int characterId) {
        int[] existing = this.getIntArray(this.PARTY());
        if (add3) {
            if (Predef$.MODULE$.intArrayOps(existing).contains(BoxesRunTime.boxToInteger(characterId))) {
                return false;
            }
            int[] newParty = (int[])Predef$.MODULE$.intArrayOps(existing).$colon$plus(BoxesRunTime.boxToInteger(characterId), ClassTag$.MODULE$.Int());
            this.setIntArray(this.PARTY(), newParty);
            return true;
        }
        if (Predef$.MODULE$.intArrayOps(existing).contains(BoxesRunTime.boxToInteger(characterId))) {
            this.setIntArray(this.PARTY(), (int[])Predef$.MODULE$.intArrayOps(existing).filter(new scala.Serializable(this, characterId){
                private final int characterId$1;

                public final boolean apply(int x$4) {
                    return this.apply$mcZI$sp(x$4);
                }

                public boolean apply$mcZI$sp(int x$4) {
                    return x$4 != this.characterId$1;
                }
                {
                    this.characterId$1 = characterId$1;
                }
            }));
            return true;
        }
        return false;
    }

    public boolean addRemoveItem(int itemId, int qtyDelta) {
        block10: {
            block9: {
                boolean itemExistsInInventory;
                int idxOfItem;
                int[] itemIds;
                int[] itemQtys;
                block8: {
                    Predef$.MODULE$.assert(itemId >= 0);
                    Predef$.MODULE$.assert(qtyDelta != 0);
                    itemQtys = this.getIntArray(this.INVENTORY_QTYS());
                    itemIds = this.getIntArray(this.INVENTORY_ITEM_IDS());
                    idxOfItem = Predef$.MODULE$.intArrayOps(itemIds).indexOf(BoxesRunTime.boxToInteger(itemId));
                    boolean bl = itemExistsInInventory = idxOfItem != -1;
                    if (qtyDelta <= 0) break block8;
                    if (itemExistsInInventory) {
                        itemQtys[idxOfItem] = itemQtys[idxOfItem] + qtyDelta;
                        this.setIntArray(this.INVENTORY_QTYS(), itemQtys);
                    } else {
                        this.setIntArray(this.INVENTORY_QTYS(), (int[])Predef$.MODULE$.intArrayOps(itemQtys).$plus$plus(Predef$.MODULE$.intArrayOps(new int[]{qtyDelta}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                        this.setIntArray(this.INVENTORY_ITEM_IDS(), (int[])Predef$.MODULE$.intArrayOps(itemIds).$plus$plus(Predef$.MODULE$.intArrayOps(new int[]{itemId}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                    }
                    break block9;
                }
                if (!itemExistsInInventory) break block10;
                if (itemQtys[idxOfItem] < -qtyDelta) {
                    return false;
                }
                itemQtys[idxOfItem] = itemQtys[idxOfItem] + qtyDelta;
                if (itemQtys[idxOfItem] == 0) {
                    int[] newItemQtys = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(itemQtys).reverse()).dropWhile(new scala.Serializable(this){

                        public final boolean apply(int x$5) {
                            return this.apply$mcZI$sp(x$5);
                        }

                        public boolean apply$mcZI$sp(int x$5) {
                            return x$5 <= 0;
                        }
                    })).reverse();
                    this.setIntArray(this.INVENTORY_QTYS(), newItemQtys);
                    this.setIntArray(this.INVENTORY_ITEM_IDS(), (int[])Predef$.MODULE$.intArrayOps(itemIds).take(Predef$.MODULE$.intArrayOps(newItemQtys).size()));
                } else {
                    this.setIntArray(this.INVENTORY_QTYS(), itemQtys);
                    this.setIntArray(this.INVENTORY_ITEM_IDS(), itemIds);
                }
            }
            return true;
        }
        return false;
    }

    public int countItems(int itemId) {
        Predef$.MODULE$.assert(itemId >= 0);
        int[] itemQtys = this.getIntArray(this.INVENTORY_QTYS());
        int[] itemIds = this.getIntArray(this.INVENTORY_ITEM_IDS());
        int idxOfItem = Predef$.MODULE$.intArrayOps(itemIds).indexOf(BoxesRunTime.boxToInteger(itemId));
        boolean itemExistsInInventory = idxOfItem != -1;
        return itemExistsInInventory ? itemQtys[idxOfItem] : 0;
    }

    public int[] getEquippableItems(ProjectData pData, int characterId, int equipTypeId) {
        this.assertOnBoundThread();
        Predef$.MODULE$.assume(characterId < pData.enums().characters().length);
        Predef$.MODULE$.assume(equipTypeId < pData.enums().equipTypes().length);
        int[] itemIds = this.getIntArray(this.INVENTORY_ITEM_IDS());
        int[] itemQtys = this.getIntArray(this.INVENTORY_QTYS());
        Predef$.MODULE$.assert(itemQtys.length == itemIds.length);
        Character character = pData.enums().characters()[characterId];
        Predef$.MODULE$.assert(character.charClass() < pData.enums().classes().length);
        CharClass characterClass = pData.enums().classes()[character.charClass()];
        ArrayBuffer equippableItemIds = new ArrayBuffer();
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(itemIds).zip(Predef$.MODULE$.wrapIntArray(itemQtys), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter(new scala.Serializable(this){

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1<Tuple2<Object, Object>, Object>)((Object)new scala.Serializable(this){

            public final boolean apply(Tuple2<Object, Object> x$6) {
                Tuple2<Object, Object> tuple2 = x$6;
                if (tuple2 != null) {
                    int itemQty = tuple2._2$mcI$sp();
                    boolean bl = itemQty > 0;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).foreach(new scala.Serializable(this, pData, equipTypeId, characterClass, equippableItemIds){
            private final ProjectData pData$5;
            private final int equipTypeId$1;
            private final CharClass characterClass$1;
            private final ArrayBuffer equippableItemIds$1;

            public final void apply(Tuple2<Object, Object> x$7) {
                Tuple2<Object, Object> tuple2 = x$7;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    int itemId = tuple2._1$mcI$sp();
                    Predef$.MODULE$.assert(itemId < this.pData$5.enums().items().length);
                    Item item = this.pData$5.enums().items()[itemId];
                    if (item.itemTypeId() == ItemType$.MODULE$.Equipment().id() && item.equipType() == this.equipTypeId$1 && Predef$.MODULE$.intArrayOps(this.characterClass$1.canUseItems()).contains(BoxesRunTime.boxToInteger(itemId))) {
                        this.equippableItemIds$1.append(Predef$.MODULE$.wrapIntArray(new int[]{itemId}));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pData$5 = pData$5;
                this.equipTypeId$1 = equipTypeId$1;
                this.characterClass$1 = characterClass$1;
                this.equippableItemIds$1 = equippableItemIds$1;
            }
        });
        return (int[])equippableItemIds.toArray(ClassTag$.MODULE$.Int());
    }

    public Tuple2<Object, Object>[] getBattleItems(ProjectData pData) {
        this.assertOnBoundThread();
        int[] itemIds = this.getIntArray(this.INVENTORY_ITEM_IDS());
        int[] itemQtys = this.getIntArray(this.INVENTORY_QTYS());
        Predef$.MODULE$.assert(itemQtys.length == itemIds.length);
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(itemIds).zip(Predef$.MODULE$.wrapIntArray(itemQtys), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter(new scala.Serializable(this, pData){
            private final ProjectData pData$1;

            public final boolean apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int itemId = tuple2._1$mcI$sp();
                    int itemQty = tuple2._2$mcI$sp();
                    boolean bl = itemQty > 0 && itemId < this.pData$1.enums().items().length && this.pData$1.enums().items()[itemId].usableInBattle();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pData$1 = pData$1;
            }
        });
    }

    public boolean equipItem(int characterId, int slotId, int itemId) {
        int currentItemId;
        boolean removed;
        if (itemId >= 0 && !(removed = this.addRemoveItem(itemId, -1))) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringOps(Predef$.MODULE$.augmentString("Item %d not in inventory. Cannot equip.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(itemId)})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return false;
        }
        int[] currentEquipment = this.getIntArray(this.CHARACTER_EQUIP(characterId));
        Serializable serializable = slotId < currentEquipment.length ? ((currentItemId = currentEquipment[slotId]) >= 0 ? BoxesRunTime.boxToBoolean(this.addRemoveItem(currentItemId, 1)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        int[] resizedAry = slotId < currentEquipment.length ? currentEquipment : (int[])ArrayUtils$.MODULE$.resized(currentEquipment, slotId + 1, new scala.Serializable(this){

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return -1;
            }
        }, ManifestFactory$.MODULE$.Int());
        resizedAry[slotId] = itemId;
        this.setIntArray(this.CHARACTER_EQUIP(characterId), resizedAry);
        return true;
    }

    public void addRemoveLearnedSkills(boolean add3, int characterId, int skillId) {
        int[] existingSkills = this.getIntArray(this.CHARACTER_LEARNED_SKILLS(characterId));
        int[] newSkills = add3 ? (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(existingSkills).$colon$plus(BoxesRunTime.boxToInteger(skillId), ClassTag$.MODULE$.Int())).distinct() : (int[])Predef$.MODULE$.intArrayOps(existingSkills).filterNot(new scala.Serializable(this, skillId){
            private final int skillId$1;

            public final boolean apply(int x$8) {
                return this.apply$mcZI$sp(x$8);
            }

            public boolean apply$mcZI$sp(int x$8) {
                return x$8 == this.skillId$1;
            }
            {
                this.skillId$1 = skillId$1;
            }
        });
        this.setIntArray(this.CHARACTER_LEARNED_SKILLS(characterId), newSkills);
    }

    public boolean addRemoveGold(int delta) {
        int gold = this.getInt(this.GOLD());
        int newGold = gold + delta;
        if (delta < 0 && newGold < 0) {
            return false;
        }
        this.setInt(this.GOLD(), newGold);
        return true;
    }

    public final Character[] rpgboss$player$PersistentState$$characters$1(ProjectData pData$2) {
        return pData$2.enums().characters();
    }

    private final Character[] characters$3(ProjectData pData$4) {
        return pData$4.enums().characters();
    }

    private final Character[] characters$2(ProjectData pData$3) {
        return pData$3.enums().characters();
    }

    public PersistentState(SaveFile initial) {
        ThreadChecked$class.$init$(this);
        Publisher$class.$init$(this);
        HasScriptConstants$class.$init$(this);
        LazyLogging$class.$init$(this);
        this.intMap = new HashMap();
        this.intMap().$plus$plus$eq((TraversableOnce<Tuple2<String, Object>>)initial.intMap());
        this.stringMap = new HashMap();
        this.stringMap().$plus$plus$eq((TraversableOnce<Tuple2<String, String>>)initial.stringMap());
        this.intArrayMap = new HashMap();
        this.intArrayMap().$plus$plus$eq((TraversableOnce<Tuple2<String, int[]>>)initial.intArrayMap());
        this.stringArrayMap = new HashMap();
        this.stringArrayMap().$plus$plus$eq((TraversableOnce<Tuple2<String, String[]>>)initial.stringArrayMap());
        this.mapLocMap = new HashMap();
        this.mapLocMap().$plus$plus$eq((TraversableOnce<Tuple2<String, MapLoc>>)initial.mapLocMap());
        this.eventStates = new HashMap();
        this.eventStates().$plus$plus$eq(Predef$.MODULE$.refArrayOps((Object[])initial.eventStates()).map(new scala.Serializable(this){

            public final Tuple2<Tuple2<String, Object>, Object> apply(SavedEventState es) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new Tuple2<String, Integer>(es.mapName(), BoxesRunTime.boxToInteger(es.eventId()))), BoxesRunTime.boxToInteger(es.eventState()));
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit())));
    }
}

